#!/usr/bin/perl
use utf8;

use DBI;

my($dsn)='DBI:mysql:accounts:localhost';
my($dbUser)='accounts';
my($dbPass)='copernicus';
my($dbh)=0;

my($debug) = 1;

&main;

sub main
{
	$dbh = DBI->connect($dsn, $dbUser, $dbPass);

	## CATEGORY setup
	#&setupCategory($dbh);

	## SUBCATEGORY setup
	#&setupSubcategory($dbh);

	## payFrom setup
	&setupPayFrom($dbh);


	## bankAccount setup
	&setupBankAccount($dbh);


	&halt;	
}

sub setupCategory
{
	my($handle) = $_[0];


	open(DATAFILE, "< category.txt") or die("error :$!");
	my @lines = <DATAFILE>;
	close(DATAFILE);

	for(my $i=0; $i<@lines; $i++)
	{
		if ($lines[$i] =~ /^(.+?)\t([-\d]+)(\t(.+))?/s)
		{
			my($cat, $outgoing, $desc) = ($1, $2, $3);
			$desc =~ s/\s//ig;


			if ($debug != 1){
				$handle->do("INSERT INTO category SET catName=\"$cat\", outgoing=\"$outgoing\", description=\"$desc\", valid=\"1\";");
			} else {
				&debugPrint("INSERT INTO category SET catName=\"$cat\", outgoing=\"$outgoing\", description=\"$desc\", valid=\"1\";");
			}
			
		}
	}

}

sub setupSubcategory
{
	my($handle) = $_[0];


	open(DATAFILE, "< subcategory.txt") or die("error :$!");
	my @lines = <DATAFILE>;
	close(DATAFILE);

	for(my $i=0; $i<@lines; $i++)
	{
		if ($lines[$i] =~ /^(.+?)(\t(.+))?$/s)
		{
			my($cat, $sub) = ($1, $2);
			my($id) =  $handle->selectrow_array("SELECT catID FROM category WHERE catName=\"$cat\";");
			
			$sub =~ s/^\t//;

			my(@subcats) = split(/\t/, $sub);
			foreach $each (@subcats){
				$each =~ s/\s//ig;

				if ($debug != 1){
					$handle->do("INSERT INTO subcategory SET subcatName=\"$each\", catID=\"$id\", description=\"\", valid=\"1\";");
				} else {
					&debugPrint("INSERT INTO subcategory SET subcatName=\"$each\", catID=\"$id\", description=\"\", valid=\"1\";");
				}
			}		
		}
	}

}

sub setupPayFrom{
	my($handle) = $_[0];


	open(DATAFILE, "< payFrom.txt") or die("error :$!");
	my @lines = <DATAFILE>;
	close(DATAFILE);

	for(my $i=0; $i<@lines; $i++)
	{
		if ($lines[$i] =~ /^.+?$/s)
		{
			my($payer) = $&;
			if ($debug != 1){
				$handle->do("INSERT INTO payFrom SET payerName=\"$payer\", valid=\"1\";");
			} else {
				&debugPrint("INSERT INTO payFrom SET payerName=\"$payer\", valid=\"1\";");
			}
			
		}
	}

}

sub setupBankAccount{
	my($handle) = $_[0];


	open(DATAFILE, "< bankAccount.txt") or die("error :$!");
	my @lines = <DATAFILE>;
	close(DATAFILE);

	for(my $i=0; $i<@lines; $i++)
	{
		if ($lines[$i] =~ /^.+?$/s)
		{
			my($account) = $&;

			if ($debug != 1){
				$handle->do("INSERT INTO bankAccount SET accountName=\"$account\", valid=\"1\";");
			} else {
				&debugPrint("INSERT INTO bankAccount SET accountName=\"$account\", valid=\"1\";");
			}
			
		}
	}

}

sub debugPrint
{
	my $message = $_[0];
	print $message."\n";
}

sub halt{
	$dbh->disconnect;
	exit;
}